/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.util;

import org.sonar.api.utils.log.Logger;
import org.sonar.api.utils.log.Loggers;

public class ProgressReport
implements Runnable {
    private static final Logger LOG = Loggers.get(ProgressReport.class);
    private final long period;
    private String message = "";
    private final Thread thread;
    private String stopMessage = "";

    public ProgressReport(String threadName, long period) {
        this.period = period;
        this.thread = new Thread(this);
        this.thread.setName(threadName);
        this.thread.setDaemon(true);
    }

    @Override
    public void run() {
        while (!Thread.interrupted()) {
            try {
                Thread.sleep(this.period);
                ProgressReport.log(this.message);
            }
            catch (InterruptedException e) {
                // empty catch block
                break;
            }
        }
        ProgressReport.log(this.stopMessage);
    }

    public void start(String startMessage) {
        ProgressReport.log(startMessage);
        this.thread.start();
    }

    public void message(String message) {
        this.message = message;
    }

    public void stop(String stopMessage) {
        this.stopMessage = stopMessage;
        this.thread.interrupt();
        try {
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(String message) {
        Logger logger = LOG;
        synchronized (logger) {
            LOG.info(message);
            LOG.notifyAll();
        }
    }
}

